@echo off
title Greek Driver Updater - Universal Installer
color 0B

echo.
echo  ╔══════════════════════════════════════════════════════════════╗
echo  ║                    Greek Driver Updater                      ║
echo  ║                   Universal Installer                        ║
echo  ║                  by Greek Squad USA                          ║
echo  ╚══════════════════════════════════════════════════════════════╝
echo.

REM Check if running as administrator
net session >nul 2>&1
if %errorLevel% == 0 (
    echo ✅ Administrator privileges detected
) else (
    echo ❌ Administrator privileges required
    echo Please right-click and "Run as Administrator"
    pause
    exit /b 1
)

echo.
echo 🔍 Detecting system specifications...

REM Detect Windows version
for /f "tokens=4-5 delims=. " %%i in ('ver') do set VERSION=%%i.%%j
echo    Windows Version: %VERSION%

REM Check if Windows 10/11 compatible
if "%VERSION%" geq "10.0" (
    echo ✅ Windows 10/11 compatible
    set COMPATIBLE=1
) else (
    echo ❌ Windows 10 or later required
    set COMPATIBLE=0
)

REM Detect system architecture
if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
    echo ✅ 64-bit system detected
    set ARCH=x64
) else (
    echo ⚠️  32-bit system detected
    set ARCH=x86
)

REM Check available memory
for /f "skip=1" %%p in ('wmic computersystem get TotalPhysicalMemory') do (
    set /a MEMORY_GB=%%p/1024/1024/1024
    goto :memory_done
)
:memory_done
echo    Available Memory: %MEMORY_GB%GB

if %MEMORY_GB% geq 4 (
    echo ✅ Sufficient memory
) else (
    echo ⚠️  Low memory - 4GB+ recommended
)

REM Detect printers
echo.
echo 🖨️  Detecting printers...
powershell -Command "Get-WmiObject -Class Win32_Printer | Measure-Object | Select-Object -ExpandProperty Count" > temp_printer_count.txt
set /p PRINTER_COUNT=<temp_printer_count.txt
del temp_printer_count.txt
echo    Printers found: %PRINTER_COUNT%

echo.
echo 📋 System Compatibility Report:
echo ================================
if %COMPATIBLE%==1 (
    echo Status: ✅ COMPATIBLE
) else (
    echo Status: ❌ NOT COMPATIBLE
    echo.
    echo This system does not meet minimum requirements.
    echo Please upgrade to Windows 10 or later.
    pause
    exit /b 1
)

echo.
echo 📦 Installing Greek Driver Updater...

REM Create installation directory
set INSTALL_DIR=%PROGRAMFILES%\Greek Squad USA\Greek Driver Updater
if not exist "%INSTALL_DIR%" mkdir "%INSTALL_DIR%"

REM Copy application files
echo    Copying application files...
xcopy /E /I /Y "src" "%INSTALL_DIR%\src\" >nul
xcopy /E /I /Y "public" "%INSTALL_DIR%\public\" >nul
copy /Y "package.json" "%INSTALL_DIR%\" >nul
copy /Y "preview.html" "%INSTALL_DIR%\" >nul
copy /Y "*.md" "%INSTALL_DIR%\" >nul

REM Create adaptive configuration
echo    Creating system-specific configuration...
echo { > "%INSTALL_DIR%\system-config.json"
echo   "windowsVersion": "%VERSION%", >> "%INSTALL_DIR%\system-config.json"
echo   "architecture": "%ARCH%", >> "%INSTALL_DIR%\system-config.json"
echo   "memoryGB": %MEMORY_GB%, >> "%INSTALL_DIR%\system-config.json"
echo   "printerCount": %PRINTER_COUNT%, >> "%INSTALL_DIR%\system-config.json"
echo   "installDate": "%DATE% %TIME%", >> "%INSTALL_DIR%\system-config.json"
echo   "features": { >> "%INSTALL_DIR%\system-config.json"
if %MEMORY_GB% geq 8 (
    echo     "animations": true, >> "%INSTALL_DIR%\system-config.json"
) else (
    echo     "animations": false, >> "%INSTALL_DIR%\system-config.json"
)
echo     "driverUpdates": true, >> "%INSTALL_DIR%\system-config.json"
echo     "securityScanning": true >> "%INSTALL_DIR%\system-config.json"
echo   } >> "%INSTALL_DIR%\system-config.json"
echo } >> "%INSTALL_DIR%\system-config.json"

REM Create desktop shortcut
echo    Creating desktop shortcut...
echo Set oWS = WScript.CreateObject("WScript.Shell") > "%TEMP%\shortcut.vbs"
echo sLinkFile = "%USERPROFILE%\Desktop\Greek Driver Updater.lnk" >> "%TEMP%\shortcut.vbs"
echo Set oLink = oWS.CreateShortcut(sLinkFile) >> "%TEMP%\shortcut.vbs"
echo oLink.TargetPath = "%INSTALL_DIR%\preview.html" >> "%TEMP%\shortcut.vbs"
echo oLink.WorkingDirectory = "%INSTALL_DIR%" >> "%TEMP%\shortcut.vbs"
echo oLink.Description = "Greek Driver Updater by Greek Squad USA" >> "%TEMP%\shortcut.vbs"
echo oLink.Save >> "%TEMP%\shortcut.vbs"
cscript "%TEMP%\shortcut.vbs" >nul
del "%TEMP%\shortcut.vbs"

REM Create start menu entry
echo    Adding to Start Menu...
if not exist "%APPDATA%\Microsoft\Windows\Start Menu\Programs\Greek Squad USA" mkdir "%APPDATA%\Microsoft\Windows\Start Menu\Programs\Greek Squad USA"
echo Set oWS = WScript.CreateObject("WScript.Shell") > "%TEMP%\startmenu.vbs"
echo sLinkFile = "%APPDATA%\Microsoft\Windows\Start Menu\Programs\Greek Squad USA\Greek Driver Updater.lnk" >> "%TEMP%\startmenu.vbs"
echo Set oLink = oWS.CreateShortcut(sLinkFile) >> "%TEMP%\startmenu.vbs"
echo oLink.TargetPath = "%INSTALL_DIR%\preview.html" >> "%TEMP%\startmenu.vbs"
echo oLink.WorkingDirectory = "%INSTALL_DIR%" >> "%TEMP%\startmenu.vbs"
echo oLink.Description = "Greek Driver Updater by Greek Squad USA" >> "%TEMP%\startmenu.vbs"
echo oLink.Save >> "%TEMP%\startmenu.vbs"
cscript "%TEMP%\startmenu.vbs" >nul
del "%TEMP%\startmenu.vbs"

REM Register uninstaller
echo    Registering uninstaller...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GreekDriverUpdater" /v "DisplayName" /t REG_SZ /d "Greek Driver Updater" /f >nul
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GreekDriverUpdater" /v "Publisher" /t REG_SZ /d "Greek Squad USA" /f >nul
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GreekDriverUpdater" /v "DisplayVersion" /t REG_SZ /d "1.0.0" /f >nul
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GreekDriverUpdater" /v "InstallLocation" /t REG_SZ /d "%INSTALL_DIR%" /f >nul

echo.
echo ✅ Installation Complete!
echo.
echo 📍 Installed to: %INSTALL_DIR%
echo 🖥️  Desktop shortcut created
echo 📱 Start menu entry added
echo.
echo 📞 Support: +1 (888) 401-3698
echo 📧 Email: support@greeksquadusa.com
echo 🌐 Website: www.greeksquadusa.com
echo.
echo Press any key to launch Greek Driver Updater...
pause >nul

REM Launch the application
start "" "%INSTALL_DIR%\preview.html"

echo.
echo Thank you for choosing Greek Squad USA!
timeout /t 3 >nul
