const { contextBridge, ipcRenderer } = require('electron');

contextBridge.exposeInMainWorld('electronAPI', {
  // Enhanced driver update functions
  updateDriver: (manufacturer) => ipcRenderer.invoke('update-driver', manufacturer),
  // Flexible download: support (manufacturer, model) or ({...driverInfo})
  downloadDriver: (arg1, arg2) => {
    if (typeof arg1 === 'object' && arg1 !== null) {
      return ipcRenderer.invoke('download-driver-legacy', arg1);
    }
    return ipcRenderer.invoke('download-driver', arg1, arg2);
  },
  checkDriverUpdates: () => ipcRenderer.invoke('check-driver-updates'),
  getPrinters: () => ipcRenderer.invoke('get-printers'),
  getPrinterDrivers: () => ipcRenderer.invoke('get-printer-drivers'),
  
  // Real-time system monitoring
  scanSystem: () => ipcRenderer.invoke('scan-system'),
  checkAppUpdates: () => ipcRenderer.invoke('check-app-updates'),
  checkUpdates: () => ipcRenderer.invoke('check-updates'),
  upgradeApp: (appId) => ipcRenderer.invoke('upgrade-app', appId),
  restartPrintSpooler: () => ipcRenderer.invoke('restart-print-spooler'),
  startMonitoring: () => ipcRenderer.invoke('start-monitoring'),
  stopMonitoring: () => ipcRenderer.invoke('stop-monitoring'),
  getSystemStatus: () => ipcRenderer.invoke('get-system-status'),
  
  // License management
  getLicenseStatus: () => ipcRenderer.invoke('get-license-status'),
  activateLicense: (licenseKey, email) => ipcRenderer.invoke('activate-license', licenseKey, email),
  deactivateLicense: () => ipcRenderer.invoke('deactivate-license'),
  generateLicenseKey: (email, years) => ipcRenderer.invoke('generate-license-key', email, years),
  
  // User authentication
  registerUser: (userData) => ipcRenderer.invoke('register-user', userData),
  loginUser: (arg1, arg2) => {
    if (typeof arg1 === 'object' && arg1 !== null) {
      return ipcRenderer.invoke('login-user', arg1);
    }
    return ipcRenderer.invoke('login-user', { email: arg1, password: arg2 });
  },
  logoutUser: () => ipcRenderer.invoke('logout-user'),
  getCurrentUser: () => ipcRenderer.invoke('get-current-user'),
  updateUserProfile: (profileData) => ipcRenderer.invoke('update-user-profile', profileData),
  changePassword: (passwordData) => ipcRenderer.invoke('change-password', passwordData),
  
  // Enhanced logging
  writeLog: (message) => ipcRenderer.invoke('write-log', message),
  readLogs: () => ipcRenderer.invoke('read-logs'),

  // Real-time event listeners
  onScanCompleted: (callback) => ipcRenderer.on('scan-completed', callback),
  onUpdatesAvailable: (callback) => ipcRenderer.on('updates-available', callback),
  onSecurityAlert: (callback) => ipcRenderer.on('security-alert', callback),
  onInitialScanComplete: (callback) => ipcRenderer.on('initial-scan-complete', callback),
  onSecurityLogEntry: (callback) => ipcRenderer.on('security-log-entry', callback),
  
  // Remove event listeners
  removeAllListeners: (channel) => ipcRenderer.removeAllListeners(channel),

  // Security config & firewall
  securityGetConfig: () => ipcRenderer.invoke('security-get-config'),
  securityUpdateConfig: (patch) => ipcRenderer.invoke('security-update-config', patch),
  securityValidateUrl: (url) => ipcRenderer.invoke('security-validate-url', url),
  firewallBlockDomain: (domain) => ipcRenderer.invoke('firewall-block-domain', domain),
  firewallUnblockDomain: (domain) => ipcRenderer.invoke('firewall-unblock-domain', domain),
  firewallListRules: () => ipcRenderer.invoke('firewall-list-rules')
});
