import React from 'react';
import { 
  TrashIcon,
  ExclamationTriangleIcon,
  CheckCircleIcon,
  FolderIcon,
  CogIcon,
  ComputerDesktopIcon,
  DocumentTextIcon,
  ArrowPathIcon,
  PhoneIcon,
  EnvelopeIcon,
  ClipboardDocumentListIcon
} from '@heroicons/react/24/outline';

const UninstallInstructions = () => {
  const copyToClipboard = (text) => {
    navigator.clipboard.writeText(text);
  };

  return (
    <div className="max-w-4xl mx-auto p-6">
      {/* Header */}
      <div className="text-center mb-8">
        <div className="flex items-center justify-center mb-4">
          <TrashIcon className="h-12 w-12 text-red-600 mr-3" />
          <h1 className="text-3xl font-bold text-gray-900">Uninstall Instructions</h1>
        </div>
        <p className="text-gray-600">Complete removal guide for Greek Driver Updater</p>
        <p className="text-sm text-gray-500 mt-2">Follow these steps to completely remove the software from your system</p>
      </div>

      <div className="space-y-8">
        
        {/* Important Notice */}
        <div className="bg-yellow-50 border border-yellow-200 rounded-lg p-6">
          <div className="flex items-start">
            <ExclamationTriangleIcon className="h-6 w-6 text-yellow-600 mr-3 mt-0.5" />
            <div>
              <h2 className="text-lg font-semibold text-yellow-800 mb-2">Before You Uninstall</h2>
              <ul className="text-yellow-700 space-y-1 text-sm">
                <li>• Close the Greek Driver Updater application completely</li>
                <li>• Save any important logs or reports you may need</li>
                <li>• Note your license key if you plan to reinstall later</li>
                <li>• Consider backing up your user profile settings</li>
              </ul>
            </div>
          </div>
        </div>

        {/* Method 1: Windows Settings */}
        <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <CogIcon className="h-6 w-6 text-blue-600 mr-2" />
            Method 1: Windows Settings (Recommended)
          </h2>
          
          <div className="space-y-4">
            <div className="flex items-start">
              <div className="bg-blue-100 rounded-full w-6 h-6 flex items-center justify-center text-blue-600 font-semibold text-sm mr-3 mt-0.5">1</div>
              <div>
                <h3 className="font-medium text-gray-900">Open Windows Settings</h3>
                <p className="text-gray-600 text-sm">Press <kbd className="px-2 py-1 bg-gray-100 rounded text-xs">Win + I</kbd> or click Start → Settings</p>
              </div>
            </div>

            <div className="flex items-start">
              <div className="bg-blue-100 rounded-full w-6 h-6 flex items-center justify-center text-blue-600 font-semibold text-sm mr-3 mt-0.5">2</div>
              <div>
                <h3 className="font-medium text-gray-900">Navigate to Apps</h3>
                <p className="text-gray-600 text-sm">Click on "Apps" or "Apps & features"</p>
              </div>
            </div>

            <div className="flex items-start">
              <div className="bg-blue-100 rounded-full w-6 h-6 flex items-center justify-center text-blue-600 font-semibold text-sm mr-3 mt-0.5">3</div>
              <div>
                <h3 className="font-medium text-gray-900">Find Greek Driver Updater</h3>
                <p className="text-gray-600 text-sm">Search for "Greek Driver Updater" in the app list</p>
              </div>
            </div>

            <div className="flex items-start">
              <div className="bg-blue-100 rounded-full w-6 h-6 flex items-center justify-center text-blue-600 font-semibold text-sm mr-3 mt-0.5">4</div>
              <div>
                <h3 className="font-medium text-gray-900">Uninstall</h3>
                <p className="text-gray-600 text-sm">Click on the app, then click "Uninstall" and confirm</p>
              </div>
            </div>
          </div>
        </div>

        {/* Method 2: Control Panel */}
        <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <ComputerDesktopIcon className="h-6 w-6 text-blue-600 mr-2" />
            Method 2: Control Panel (Alternative)
          </h2>
          
          <div className="space-y-4">
            <div className="flex items-start">
              <div className="bg-green-100 rounded-full w-6 h-6 flex items-center justify-center text-green-600 font-semibold text-sm mr-3 mt-0.5">1</div>
              <div>
                <h3 className="font-medium text-gray-900">Open Control Panel</h3>
                <p className="text-gray-600 text-sm">Press <kbd className="px-2 py-1 bg-gray-100 rounded text-xs">Win + R</kbd>, type <code className="bg-gray-100 px-1 rounded">appwiz.cpl</code>, press Enter</p>
              </div>
            </div>

            <div className="flex items-start">
              <div className="bg-green-100 rounded-full w-6 h-6 flex items-center justify-center text-green-600 font-semibold text-sm mr-3 mt-0.5">2</div>
              <div>
                <h3 className="font-medium text-gray-900">Locate the Application</h3>
                <p className="text-gray-600 text-sm">Find "Greek Driver Updater" in the Programs and Features list</p>
              </div>
            </div>

            <div className="flex items-start">
              <div className="bg-green-100 rounded-full w-6 h-6 flex items-center justify-center text-green-600 font-semibold text-sm mr-3 mt-0.5">3</div>
              <div>
                <h3 className="font-medium text-gray-900">Remove</h3>
                <p className="text-gray-600 text-sm">Right-click on the application and select "Uninstall" or click "Uninstall" button</p>
              </div>
            </div>
          </div>
        </div>

        {/* Manual Cleanup */}
        <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <FolderIcon className="h-6 w-6 text-orange-600 mr-2" />
            Manual Cleanup (Optional)
          </h2>
          
          <p className="text-gray-600 mb-4 text-sm">
            After uninstalling, you may want to remove leftover files and settings:
          </p>

          <div className="space-y-4">
            <div className="bg-orange-50 rounded-lg p-4">
              <h3 className="font-semibold text-orange-800 mb-2">User Data Location</h3>
              <div className="flex items-center justify-between bg-white rounded p-2 border">
                <code className="text-sm text-gray-700">%USERPROFILE%\AppData\Local\GreekDriverUpdater</code>
                <button
                  onClick={() => copyToClipboard('%USERPROFILE%\\AppData\\Local\\GreekDriverUpdater')}
                  className="text-blue-600 hover:text-blue-700 p-1"
                  title="Copy path"
                >
                  <ClipboardDocumentListIcon className="h-4 w-4" />
                </button>
              </div>
              <p className="text-orange-700 text-sm mt-2">
                This folder contains your license data, user profiles, and application logs.
              </p>
            </div>

            <div className="bg-gray-50 rounded-lg p-4">
              <h3 className="font-semibold text-gray-800 mb-2">How to Access</h3>
              <ol className="text-gray-700 space-y-1 text-sm list-decimal list-inside">
                <li>Press <kbd className="px-2 py-1 bg-gray-100 rounded text-xs">Win + R</kbd> to open Run dialog</li>
                <li>Type <code className="bg-gray-100 px-1 rounded">%USERPROFILE%\AppData\Local\GreekDriverUpdater</code></li>
                <li>Press Enter to open the folder</li>
                <li>Delete the entire folder if you want to remove all user data</li>
              </ol>
            </div>
          </div>
        </div>

        {/* Registry Cleanup */}
        <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <DocumentTextIcon className="h-6 w-6 text-red-600 mr-2" />
            Registry Cleanup (Advanced Users Only)
          </h2>
          
          <div className="bg-red-50 border border-red-200 rounded-lg p-4 mb-4">
            <div className="flex items-start">
              <ExclamationTriangleIcon className="h-5 w-5 text-red-600 mr-2 mt-0.5" />
              <div>
                <h3 className="font-semibold text-red-800 mb-1">Warning</h3>
                <p className="text-red-700 text-sm">
                  Editing the registry can damage your system if done incorrectly. Only proceed if you are 
                  experienced with registry editing and have created a system backup.
                </p>
              </div>
            </div>
          </div>

          <div className="space-y-3">
            <h3 className="font-medium text-gray-900">Registry Locations to Check:</h3>
            <div className="space-y-2">
              <div className="flex items-center justify-between bg-gray-50 rounded p-2">
                <code className="text-sm text-gray-700">HKEY_CURRENT_USER\Software\GreekSquadUSA</code>
                <button
                  onClick={() => copyToClipboard('HKEY_CURRENT_USER\\Software\\GreekSquadUSA')}
                  className="text-blue-600 hover:text-blue-700 p-1"
                  title="Copy registry path"
                >
                  <ClipboardDocumentListIcon className="h-4 w-4" />
                </button>
              </div>
              <div className="flex items-center justify-between bg-gray-50 rounded p-2">
                <code className="text-sm text-gray-700">HKEY_LOCAL_MACHINE\Software\GreekSquadUSA</code>
                <button
                  onClick={() => copyToClipboard('HKEY_LOCAL_MACHINE\\Software\\GreekSquadUSA')}
                  className="text-blue-600 hover:text-blue-700 p-1"
                  title="Copy registry path"
                >
                  <ClipboardDocumentListIcon className="h-4 w-4" />
                </button>
              </div>
            </div>
          </div>
        </div>

        {/* Verification */}
        <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <CheckCircleIcon className="h-6 w-6 text-green-600 mr-2" />
            Verify Complete Removal
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-2">
              <h3 className="font-medium text-gray-900">Check These Locations:</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Start Menu shortcuts removed</li>
                <li>• Desktop shortcuts removed</li>
                <li>• Program Files folder empty</li>
                <li>• AppData folder deleted (if desired)</li>
              </ul>
            </div>

            <div className="space-y-2">
              <h3 className="font-medium text-gray-900">System Cleanup:</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Run Disk Cleanup utility</li>
                <li>• Empty Recycle Bin</li>
                <li>• Restart computer</li>
                <li>• Check Windows Event Logs</li>
              </ul>
            </div>
          </div>
        </div>

        {/* Reinstallation */}
        <div className="bg-blue-50 rounded-lg p-6">
          <h2 className="text-xl font-semibold text-blue-900 mb-4 flex items-center">
            <ArrowPathIcon className="h-6 w-6 text-blue-600 mr-2" />
            Need to Reinstall?
          </h2>
          
          <p className="text-blue-800 mb-4">
            If you're uninstalling to fix issues, consider these alternatives first:
          </p>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="bg-white rounded p-4">
              <h3 className="font-medium text-gray-900 mb-2">Troubleshooting Options</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Restart the application</li>
                <li>• Run as Administrator</li>
                <li>• Check Windows Updates</li>
                <li>• Review application logs</li>
              </ul>
            </div>

            <div className="bg-white rounded p-4">
              <h3 className="font-medium text-gray-900 mb-2">Get Support</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Contact technical support</li>
                <li>• Check online documentation</li>
                <li>• Submit bug reports</li>
                <li>• Download latest version</li>
              </ul>
            </div>
          </div>
        </div>

        {/* Support Contact */}
        <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Need Help?</h2>
          
          <p className="text-gray-700 mb-4">
            If you encounter issues during uninstallation or need assistance:
          </p>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="flex items-center">
              <EnvelopeIcon className="h-5 w-5 text-blue-600 mr-2" />
              <a href="mailto:support@greeksquadusa.com" className="text-blue-600 hover:text-blue-700">
                support@greeksquadusa.com
              </a>
            </div>
            
            <div className="flex items-center">
              <PhoneIcon className="h-5 w-5 text-blue-600 mr-2" />
              <a href="tel:+1-888-401-3698" className="text-blue-600 hover:text-blue-700">
                +1 (888) 401-3698
              </a>
            </div>
          </div>
          
          <div className="mt-4 text-sm text-gray-600">
            <p>Greek Squad USA Technical Support</p>
            <p>Available: Monday - Friday, 9 AM - 6 PM PST</p>
            <p>www.greeksquadusa.com</p>
          </div>
        </div>

      </div>
    </div>
  );
};

export default UninstallInstructions;
