import React from 'react';
import { 
  DocumentTextIcon,
  ScaleIcon,
  ExclamationTriangleIcon,
  ShieldCheckIcon,
  CurrencyDollarIcon,
  UserIcon,
  GlobeAltIcon,
  ClockIcon,
  EnvelopeIcon,
  PhoneIcon
} from '@heroicons/react/24/outline';

const TermsOfUse = () => {
  return (
    <div className="max-w-4xl mx-auto p-6">
      {/* Header */}
      <div className="text-center mb-8">
        <div className="flex items-center justify-center mb-4">
          <ScaleIcon className="h-12 w-12 text-blue-600 mr-3" />
          <h1 className="text-3xl font-bold text-gray-900">Terms of Use</h1>
        </div>
        <p className="text-gray-600">Greek Driver Updater by Greek Squad USA</p>
        <p className="text-sm text-gray-500 mt-2">Last Updated: September 6, 2024</p>
      </div>

      <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-8 space-y-8">
        
        {/* Acceptance of Terms */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <DocumentTextIcon className="h-6 w-6 text-blue-600 mr-2" />
            Acceptance of Terms
          </h2>
          <p className="text-gray-700 leading-relaxed">
            By downloading, installing, or using Greek Driver Updater ("Software"), you agree to be bound 
            by these Terms of Use ("Terms"). If you do not agree to these Terms, do not use the Software. 
            These Terms constitute a legal agreement between you and Greek Squad USA ("Company," "we," "us," or "our").
          </p>
        </section>

        {/* License Grant */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <ShieldCheckIcon className="h-6 w-6 text-blue-600 mr-2" />
            License Grant
          </h2>
          
          <div className="space-y-4">
            <div className="bg-green-50 rounded-lg p-4">
              <h3 className="font-semibold text-green-800 mb-2">Permitted Use</h3>
              <ul className="text-green-700 space-y-1 text-sm">
                <li>• Install and use the Software on devices you own or control</li>
                <li>• Use the Software for personal or business purposes</li>
                <li>• Receive automatic updates and support during your license period</li>
                <li>• Create backups for personal use</li>
              </ul>
            </div>

            <div className="bg-red-50 rounded-lg p-4">
              <h3 className="font-semibold text-red-800 mb-2">Prohibited Activities</h3>
              <ul className="text-red-700 space-y-1 text-sm">
                <li>• Reverse engineer, decompile, or disassemble the Software</li>
                <li>• Distribute, sell, or sublicense the Software</li>
                <li>• Remove or modify copyright notices or license information</li>
                <li>• Use the Software for illegal or unauthorized purposes</li>
                <li>• Share license keys or account credentials</li>
              </ul>
            </div>
          </div>
        </section>

        {/* User Accounts */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <UserIcon className="h-6 w-6 text-blue-600 mr-2" />
            User Accounts and Registration
          </h2>
          
          <div className="space-y-3">
            <p className="text-gray-700">
              To use certain features of the Software, you must create an account and provide accurate information.
            </p>
            
            <div className="bg-blue-50 rounded-lg p-4">
              <h3 className="font-semibold text-blue-800 mb-2">Account Responsibilities</h3>
              <ul className="text-blue-700 space-y-1 text-sm">
                <li>• Provide accurate and complete registration information</li>
                <li>• Maintain the security of your account credentials</li>
                <li>• Notify us immediately of any unauthorized access</li>
                <li>• Accept responsibility for all activities under your account</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Payment and Licensing */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <CurrencyDollarIcon className="h-6 w-6 text-blue-600 mr-2" />
            Payment and Licensing
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-3">
              <h3 className="font-medium text-gray-900">Trial Period</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• 7-day free trial from installation</li>
                <li>• Full access to all features during trial</li>
                <li>• No payment required for trial period</li>
                <li>• Automatic feature restriction after trial expires</li>
              </ul>
            </div>

            <div className="space-y-3">
              <h3 className="font-medium text-gray-900">Paid Licenses</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• License keys valid for 1-10 years</li>
                <li>• Non-transferable and non-refundable</li>
                <li>• Tied to registered email address</li>
                <li>• Renewal required after expiration</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Software Updates */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <ClockIcon className="h-6 w-6 text-blue-600 mr-2" />
            Software Updates and Modifications
          </h2>
          
          <div className="bg-yellow-50 rounded-lg p-4">
            <div className="flex items-start">
              <ExclamationTriangleIcon className="h-5 w-5 text-yellow-600 mr-2 mt-0.5" />
              <div>
                <p className="text-yellow-700 text-sm mb-2">
                  We may update, modify, or discontinue the Software at any time without prior notice. 
                  Updates may include security patches, bug fixes, and new features.
                </p>
                <p className="text-yellow-700 text-sm">
                  Continued use of the Software after updates constitutes acceptance of the modified Software.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Disclaimer of Warranties */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Disclaimer of Warranties</h2>
          
          <div className="bg-gray-50 rounded-lg p-4">
            <p className="text-gray-700 text-sm leading-relaxed mb-3">
              THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. WE DISCLAIM ALL WARRANTIES, 
              EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO:
            </p>
            <ul className="text-gray-700 space-y-1 text-sm">
              <li>• MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE</li>
              <li>• NON-INFRINGEMENT OF THIRD-PARTY RIGHTS</li>
              <li>• UNINTERRUPTED OR ERROR-FREE OPERATION</li>
              <li>• COMPATIBILITY WITH ALL HARDWARE AND SOFTWARE</li>
            </ul>
          </div>
        </section>

        {/* Limitation of Liability */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Limitation of Liability</h2>
          
          <div className="bg-red-50 rounded-lg p-4">
            <p className="text-red-700 text-sm leading-relaxed">
              IN NO EVENT SHALL GREEK SQUAD USA BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL, 
              CONSEQUENTIAL, OR PUNITIVE DAMAGES, INCLUDING BUT NOT LIMITED TO LOSS OF DATA, 
              LOSS OF PROFITS, OR BUSINESS INTERRUPTION, ARISING OUT OF YOUR USE OF THE SOFTWARE, 
              EVEN IF WE HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
            </p>
          </div>
        </section>

        {/* Third-Party Software */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <GlobeAltIcon className="h-6 w-6 text-blue-600 mr-2" />
            Third-Party Software and Services
          </h2>
          
          <p className="text-gray-700 leading-relaxed mb-4">
            The Software may direct you to third-party websites or services for driver downloads. 
            We are not responsible for the content, privacy practices, or terms of use of these third parties.
          </p>
          
          <div className="bg-blue-50 rounded-lg p-4">
            <h3 className="font-semibold text-blue-800 mb-2">Your Responsibility</h3>
            <ul className="text-blue-700 space-y-1 text-sm">
              <li>• Review third-party terms and privacy policies</li>
              <li>• Verify driver authenticity before installation</li>
              <li>• Understand that third-party services are beyond our control</li>
              <li>• Report any issues with third-party services to the appropriate vendor</li>
            </ul>
          </div>
        </section>

        {/* Privacy and Data Collection */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Privacy and Data Collection</h2>
          
          <p className="text-gray-700 leading-relaxed">
            Your privacy is important to us. Our collection and use of your information is governed by our 
            Privacy Policy, which is incorporated into these Terms by reference. By using the Software, 
            you consent to our Privacy Policy.
          </p>
        </section>

        {/* Termination */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Termination</h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-2">
              <h3 className="font-medium text-gray-900">You May Terminate</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Uninstall the Software at any time</li>
                <li>• Delete your account through the application</li>
                <li>• Stop using the Software without notice</li>
              </ul>
            </div>

            <div className="space-y-2">
              <h3 className="font-medium text-gray-900">We May Terminate</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• For violation of these Terms</li>
                <li>• For fraudulent or illegal activity</li>
                <li>• With notice for business reasons</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Governing Law */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Governing Law</h2>
          
          <p className="text-gray-700 leading-relaxed">
            These Terms are governed by the laws of the State of California, United States, without 
            regard to conflict of law principles. Any disputes arising under these Terms shall be 
            resolved in the courts of California.
          </p>
        </section>

        {/* Changes to Terms */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Changes to Terms</h2>
          
          <p className="text-gray-700 leading-relaxed">
            We reserve the right to modify these Terms at any time. We will notify users of material 
            changes through the Software or by email. Continued use after changes constitutes acceptance 
            of the modified Terms.
          </p>
        </section>

        {/* Contact Information */}
        <section className="bg-blue-50 rounded-lg p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Contact Information</h2>
          <p className="text-gray-700 mb-4">
            For questions about these Terms of Use, please contact us:
          </p>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="flex items-center">
              <EnvelopeIcon className="h-5 w-5 text-blue-600 mr-2" />
              <a href="mailto:legal@greeksquadusa.com" className="text-blue-600 hover:text-blue-700">
                legal@greeksquadusa.com
              </a>
            </div>
            
            <div className="flex items-center">
              <PhoneIcon className="h-5 w-5 text-blue-600 mr-2" />
              <a href="tel:+1-888-401-3698" className="text-blue-600 hover:text-blue-700">
                +1 (888) 401-3698
              </a>
            </div>
          </div>
          
          <div className="mt-4 text-sm text-gray-600">
            <p>Greek Squad USA</p>
            <p>Silicon Valley, CA, United States</p>
            <p>www.greeksquadusa.com</p>
          </div>
        </section>

      </div>
    </div>
  );
};

export default TermsOfUse;
