import React from 'react';
import { 
  CogIcon,
  ShieldCheckIcon,
  ExclamationTriangleIcon,
  ClockIcon,
  DocumentTextIcon,
  UserGroupIcon,
  BugAntIcon,
  ArrowPathIcon,
  EnvelopeIcon,
  PhoneIcon,
  CheckCircleIcon
} from '@heroicons/react/24/outline';

const SoftwarePolicy = () => {
  return (
    <div className="max-w-4xl mx-auto p-6">
      {/* Header */}
      <div className="text-center mb-8">
        <div className="flex items-center justify-center mb-4">
          <CogIcon className="h-12 w-12 text-blue-600 mr-3" />
          <h1 className="text-3xl font-bold text-gray-900">Software Policy</h1>
        </div>
        <p className="text-gray-600">Greek Driver Updater Development & Support Guidelines</p>
        <p className="text-sm text-gray-500 mt-2">Last Updated: September 6, 2024</p>
      </div>

      <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-8 space-y-8">
        
        {/* Software Development Standards */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <ShieldCheckIcon className="h-6 w-6 text-blue-600 mr-2" />
            Development Standards
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="bg-green-50 rounded-lg p-4">
              <h3 className="font-semibold text-green-800 mb-2">Security First</h3>
              <ul className="text-green-700 space-y-1 text-sm">
                <li>• SHA-256 encryption for sensitive data</li>
                <li>• Secure local storage implementation</li>
                <li>• Regular security audits and updates</li>
                <li>• No unauthorized data transmission</li>
              </ul>
            </div>

            <div className="bg-blue-50 rounded-lg p-4">
              <h3 className="font-semibold text-blue-800 mb-2">Quality Assurance</h3>
              <ul className="text-blue-700 space-y-1 text-sm">
                <li>• Comprehensive testing before releases</li>
                <li>• User acceptance testing protocols</li>
                <li>• Performance optimization standards</li>
                <li>• Cross-platform compatibility testing</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Update Policy */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <ArrowPathIcon className="h-6 w-6 text-blue-600 mr-2" />
            Software Update Policy
          </h2>
          
          <div className="space-y-4">
            <div className="bg-blue-50 rounded-lg p-4">
              <h3 className="font-semibold text-blue-800 mb-2">Automatic Updates</h3>
              <ul className="text-blue-700 space-y-1 text-sm">
                <li>• Critical security patches: Immediate deployment</li>
                <li>• Bug fixes: Weekly release cycle</li>
                <li>• Feature updates: Monthly release cycle</li>
                <li>• Major versions: Quarterly with user notification</li>
              </ul>
            </div>

            <div className="bg-yellow-50 rounded-lg p-4">
              <div className="flex items-start">
                <ExclamationTriangleIcon className="h-5 w-5 text-yellow-600 mr-2 mt-0.5" />
                <div>
                  <h3 className="font-semibold text-yellow-800 mb-2">Update Requirements</h3>
                  <p className="text-yellow-700 text-sm mb-2">
                    Some updates may require administrator privileges or system restart. Users will be 
                    notified in advance of any disruptive updates.
                  </p>
                  <p className="text-yellow-700 text-sm">
                    Critical security updates cannot be deferred and will be applied automatically.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Support Policy */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <UserGroupIcon className="h-6 w-6 text-blue-600 mr-2" />
            Customer Support Policy
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div className="text-center p-4 border border-gray-200 rounded-lg">
              <ClockIcon className="h-8 w-8 text-blue-600 mx-auto mb-2" />
              <h3 className="font-semibold text-gray-900 mb-1">Response Time</h3>
              <p className="text-sm text-gray-600">24-48 hours for all inquiries</p>
            </div>

            <div className="text-center p-4 border border-gray-200 rounded-lg">
              <EnvelopeIcon className="h-8 w-8 text-blue-600 mx-auto mb-2" />
              <h3 className="font-semibold text-gray-900 mb-1">Email Support</h3>
              <p className="text-sm text-gray-600">support@greeksquadusa.com</p>
            </div>

            <div className="text-center p-4 border border-gray-200 rounded-lg">
              <PhoneIcon className="h-8 w-8 text-blue-600 mx-auto mb-2" />
              <h3 className="font-semibold text-gray-900 mb-1">Phone Support</h3>
              <p className="text-sm text-gray-600">Business hours: 9 AM - 6 PM PST</p>
            </div>
          </div>

          <div className="mt-6 bg-gray-50 rounded-lg p-4">
            <h3 className="font-semibold text-gray-900 mb-2">Support Scope</h3>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
              <div>
                <h4 className="font-medium text-green-800 mb-1">✓ Covered Support</h4>
                <ul className="text-gray-700 space-y-1 text-sm">
                  <li>• Software installation and setup</li>
                  <li>• License activation issues</li>
                  <li>• Driver detection problems</li>
                  <li>• Application crashes and errors</li>
                  <li>• Feature usage guidance</li>
                </ul>
              </div>

              <div>
                <h4 className="font-medium text-red-800 mb-1">✗ Not Covered</h4>
                <ul className="text-gray-700 space-y-1 text-sm">
                  <li>• Third-party driver issues</li>
                  <li>• Hardware compatibility problems</li>
                  <li>• Operating system configuration</li>
                  <li>• Network connectivity issues</li>
                  <li>• Custom software modifications</li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        {/* Bug Reporting */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <BugAntIcon className="h-6 w-6 text-blue-600 mr-2" />
            Bug Reporting and Resolution
          </h2>
          
          <div className="space-y-4">
            <div className="bg-orange-50 rounded-lg p-4">
              <h3 className="font-semibold text-orange-800 mb-2">How to Report Bugs</h3>
              <ol className="text-orange-700 space-y-1 text-sm list-decimal list-inside">
                <li>Use the built-in error reporting feature in the application</li>
                <li>Include detailed steps to reproduce the issue</li>
                <li>Attach relevant log files and system information</li>
                <li>Provide screenshots or screen recordings if applicable</li>
                <li>Send reports to bugs@greeksquadusa.com</li>
              </ol>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
              <div className="text-center p-3 bg-red-50 rounded-lg">
                <h4 className="font-medium text-red-800">Critical</h4>
                <p className="text-sm text-red-700">24 hours</p>
                <p className="text-xs text-red-600">Security or data loss issues</p>
              </div>

              <div className="text-center p-3 bg-yellow-50 rounded-lg">
                <h4 className="font-medium text-yellow-800">High</h4>
                <p className="text-sm text-yellow-700">3-5 days</p>
                <p className="text-xs text-yellow-600">Major feature failures</p>
              </div>

              <div className="text-center p-3 bg-blue-50 rounded-lg">
                <h4 className="font-medium text-blue-800">Normal</h4>
                <p className="text-sm text-blue-700">1-2 weeks</p>
                <p className="text-xs text-blue-600">Minor issues and enhancements</p>
              </div>
            </div>
          </div>
        </section>

        {/* Data and Privacy */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <DocumentTextIcon className="h-6 w-6 text-blue-600 mr-2" />
            Data Handling and Privacy
          </h2>
          
          <div className="bg-green-50 rounded-lg p-4">
            <h3 className="font-semibold text-green-800 mb-2">Our Commitments</h3>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
              <ul className="text-green-700 space-y-1 text-sm">
                <li className="flex items-center">
                  <CheckCircleIcon className="h-4 w-4 mr-2" />
                  Local data storage only
                </li>
                <li className="flex items-center">
                  <CheckCircleIcon className="h-4 w-4 mr-2" />
                  No unauthorized data collection
                </li>
                <li className="flex items-center">
                  <CheckCircleIcon className="h-4 w-4 mr-2" />
                  Encrypted sensitive information
                </li>
              </ul>

              <ul className="text-green-700 space-y-1 text-sm">
                <li className="flex items-center">
                  <CheckCircleIcon className="h-4 w-4 mr-2" />
                  User control over personal data
                </li>
                <li className="flex items-center">
                  <CheckCircleIcon className="h-4 w-4 mr-2" />
                  Transparent privacy practices
                </li>
                <li className="flex items-center">
                  <CheckCircleIcon className="h-4 w-4 mr-2" />
                  GDPR and CCPA compliance
                </li>
              </ul>
            </div>
          </div>
        </section>

        {/* Compatibility and Requirements */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">System Requirements and Compatibility</h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div className="space-y-3">
              <h3 className="font-medium text-gray-900">Minimum Requirements</h3>
              <ul className="text-gray-700 space-y-1 text-sm bg-gray-50 p-3 rounded">
                <li>• Windows 10 version 1903 or later</li>
                <li>• 4 GB RAM minimum</li>
                <li>• 500 MB available disk space</li>
                <li>• Internet connection for driver downloads</li>
                <li>• Administrator privileges for installation</li>
              </ul>
            </div>

            <div className="space-y-3">
              <h3 className="font-medium text-gray-900">Supported Printers</h3>
              <ul className="text-gray-700 space-y-1 text-sm bg-gray-50 p-3 rounded">
                <li>• HP (Hewlett-Packard)</li>
                <li>• Canon</li>
                <li>• Epson</li>
                <li>• Brother</li>
                <li>• Samsung</li>
                <li>• Lexmark, Xerox, Ricoh</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Liability and Disclaimers */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Liability and Disclaimers</h2>
          
          <div className="bg-red-50 rounded-lg p-4">
            <div className="flex items-start">
              <ExclamationTriangleIcon className="h-5 w-5 text-red-600 mr-2 mt-0.5" />
              <div>
                <h3 className="font-semibold text-red-800 mb-2">Important Disclaimers</h3>
                <ul className="text-red-700 space-y-1 text-sm">
                  <li>• We are not responsible for third-party driver compatibility issues</li>
                  <li>• Users should create system backups before major driver updates</li>
                  <li>• Hardware damage from incompatible drivers is not covered</li>
                  <li>• Business interruption or data loss is user's responsibility</li>
                  <li>• Always verify driver authenticity from manufacturer websites</li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        {/* Contact Information */}
        <section className="bg-blue-50 rounded-lg p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Policy Questions and Feedback</h2>
          <p className="text-gray-700 mb-4">
            For questions about our software policies or to provide feedback:
          </p>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="flex items-center">
              <EnvelopeIcon className="h-5 w-5 text-blue-600 mr-2" />
              <a href="mailto:policy@greeksquadusa.com" className="text-blue-600 hover:text-blue-700">
                policy@greeksquadusa.com
              </a>
            </div>
            
            <div className="flex items-center">
              <PhoneIcon className="h-5 w-5 text-blue-600 mr-2" />
              <a href="tel:+1-888-401-3698" className="text-blue-600 hover:text-blue-700">
                +1 (888) 401-3698
              </a>
            </div>
          </div>
          
          <div className="mt-4 text-sm text-gray-600">
            <p>Greek Squad USA - Software Development Team</p>
            <p>Silicon Valley, CA, United States</p>
            <p>www.greeksquadusa.com</p>
          </div>
        </section>

      </div>
    </div>
  );
};

export default SoftwarePolicy;
