import React from 'react';
import { 
  ShieldCheckIcon,
  EyeIcon,
  LockClosedIcon,
  ServerIcon,
  UserIcon,
  DocumentTextIcon,
  ExclamationTriangleIcon,
  PhoneIcon,
  EnvelopeIcon
} from '@heroicons/react/24/outline';

const PrivacyPolicy = () => {
  return (
    <div className="max-w-4xl mx-auto p-6">
      {/* Header */}
      <div className="text-center mb-8">
        <div className="flex items-center justify-center mb-4">
          <ShieldCheckIcon className="h-12 w-12 text-blue-600 mr-3" />
          <h1 className="text-3xl font-bold text-gray-900">Privacy Policy</h1>
        </div>
        <p className="text-gray-600">Greek Driver Updater by Greek Squad USA</p>
        <p className="text-sm text-gray-500 mt-2">Last Updated: September 6, 2024</p>
      </div>

      <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-8 space-y-8">
        
        {/* Introduction */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <DocumentTextIcon className="h-6 w-6 text-blue-600 mr-2" />
            Introduction
          </h2>
          <p className="text-gray-700 leading-relaxed">
            Greek Squad USA ("we," "our," or "us") is committed to protecting your privacy. This Privacy Policy 
            explains how we collect, use, disclose, and safeguard your information when you use our Greek Driver 
            Updater software application ("Application"). Please read this privacy policy carefully.
          </p>
        </section>

        {/* Information We Collect */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <EyeIcon className="h-6 w-6 text-blue-600 mr-2" />
            Information We Collect
          </h2>
          
          <div className="space-y-4">
            <div className="bg-blue-50 rounded-lg p-4">
              <h3 className="font-semibold text-gray-900 mb-2">Personal Information</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Name and email address (for account registration)</li>
                <li>• Company information (optional)</li>
                <li>• Contact information (phone, address - optional)</li>
                <li>• License key and activation details</li>
              </ul>
            </div>

            <div className="bg-gray-50 rounded-lg p-4">
              <h3 className="font-semibold text-gray-900 mb-2">System Information</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Operating system version and hardware specifications</li>
                <li>• Installed printer information and drivers</li>
                <li>• Application usage logs and error reports</li>
                <li>• Software installation and update history</li>
              </ul>
            </div>
          </div>
        </section>

        {/* How We Use Information */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <UserIcon className="h-6 w-6 text-blue-600 mr-2" />
            How We Use Your Information
          </h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-3">
              <h3 className="font-medium text-gray-900">Service Provision</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Provide driver update services</li>
                <li>• Manage user accounts and licenses</li>
                <li>• Deliver technical support</li>
                <li>• Process software activations</li>
              </ul>
            </div>

            <div className="space-y-3">
              <h3 className="font-medium text-gray-900">Improvement & Communication</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Improve application performance</li>
                <li>• Send important updates and notifications</li>
                <li>• Analyze usage patterns</li>
                <li>• Prevent fraud and abuse</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Data Storage and Security */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <LockClosedIcon className="h-6 w-6 text-blue-600 mr-2" />
            Data Storage and Security
          </h2>
          
          <div className="bg-green-50 rounded-lg p-4 mb-4">
            <h3 className="font-semibold text-green-800 mb-2">Local Storage</h3>
            <p className="text-green-700 text-sm">
              Your personal data is stored locally on your device in encrypted format. We do not transmit 
              personal information to external servers without your explicit consent.
            </p>
          </div>

          <div className="space-y-3">
            <h3 className="font-medium text-gray-900">Security Measures</h3>
            <ul className="text-gray-700 space-y-1 text-sm">
              <li>• SHA-256 encryption for password storage</li>
              <li>• Secure session management with token expiration</li>
              <li>• Local data encryption and secure file storage</li>
              <li>• Regular security updates and patches</li>
            </ul>
          </div>
        </section>

        {/* Third-Party Services */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4 flex items-center">
            <ServerIcon className="h-6 w-6 text-blue-600 mr-2" />
            Third-Party Services
          </h2>
          
          <div className="bg-yellow-50 rounded-lg p-4">
            <div className="flex items-start">
              <ExclamationTriangleIcon className="h-5 w-5 text-yellow-600 mr-2 mt-0.5" />
              <div>
                <h3 className="font-semibold text-yellow-800 mb-2">Driver Downloads</h3>
                <p className="text-yellow-700 text-sm mb-2">
                  When downloading drivers, you may be redirected to official manufacturer websites 
                  (HP, Canon, Epson, etc.). These sites have their own privacy policies.
                </p>
                <p className="text-yellow-700 text-sm">
                  We recommend reviewing the privacy policies of these manufacturers before downloading drivers.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Your Rights */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Your Privacy Rights</h2>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-2">
              <h3 className="font-medium text-gray-900">Access & Control</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• View and edit your profile information</li>
                <li>• Delete your account and associated data</li>
                <li>• Export your personal data</li>
                <li>• Opt-out of non-essential communications</li>
              </ul>
            </div>

            <div className="space-y-2">
              <h3 className="font-medium text-gray-900">Data Management</h3>
              <ul className="text-gray-700 space-y-1 text-sm">
                <li>• Request data correction or updates</li>
                <li>• Withdraw consent for data processing</li>
                <li>• Request data portability</li>
                <li>• File privacy-related complaints</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Data Retention */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Data Retention</h2>
          <div className="bg-gray-50 rounded-lg p-4">
            <ul className="text-gray-700 space-y-2 text-sm">
              <li>• <strong>Account Data:</strong> Retained while your account is active</li>
              <li>• <strong>Usage Logs:</strong> Stored locally for 90 days for troubleshooting</li>
              <li>• <strong>License Information:</strong> Retained for the duration of your license</li>
              <li>• <strong>Deleted Accounts:</strong> All data permanently removed within 30 days</li>
            </ul>
          </div>
        </section>

        {/* Children's Privacy */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Children's Privacy</h2>
          <p className="text-gray-700 leading-relaxed">
            Our Application is not intended for children under 13 years of age. We do not knowingly 
            collect personal information from children under 13. If you believe we have collected 
            information from a child under 13, please contact us immediately.
          </p>
        </section>

        {/* Changes to Privacy Policy */}
        <section>
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Changes to This Privacy Policy</h2>
          <p className="text-gray-700 leading-relaxed">
            We may update our Privacy Policy from time to time. We will notify you of any changes 
            by posting the new Privacy Policy within the Application and updating the "Last Updated" 
            date. You are advised to review this Privacy Policy periodically for any changes.
          </p>
        </section>

        {/* Contact Information */}
        <section className="bg-blue-50 rounded-lg p-6">
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Contact Us</h2>
          <p className="text-gray-700 mb-4">
            If you have any questions about this Privacy Policy, please contact us:
          </p>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="flex items-center">
              <EnvelopeIcon className="h-5 w-5 text-blue-600 mr-2" />
              <a href="mailto:privacy@greeksquadusa.com" className="text-blue-600 hover:text-blue-700">
                privacy@greeksquadusa.com
              </a>
            </div>
            
            <div className="flex items-center">
              <PhoneIcon className="h-5 w-5 text-blue-600 mr-2" />
              <a href="tel:+1-888-401-3698" className="text-blue-600 hover:text-blue-700">
                +1 (888) 401-3698
              </a>
            </div>
          </div>
          
          <div className="mt-4 text-sm text-gray-600">
            <p>Greek Squad USA</p>
            <p>Silicon Valley, CA, United States</p>
            <p>www.greeksquadusa.com</p>
          </div>
        </section>

      </div>
    </div>
  );
};

export default PrivacyPolicy;
