import React from 'react';
import { 
  BuildingOfficeIcon,
  GlobeAltIcon,
  EnvelopeIcon,
  PhoneIcon,
  MapPinIcon,
  UserGroupIcon,
  ShieldCheckIcon,
  CpuChipIcon,
  HeartIcon
} from '@heroicons/react/24/outline';

const AboutUs = () => {
  return (
    <div className="max-w-6xl mx-auto p-6">
      {/* Header */}
      <div className="text-center mb-12">
        <div className="flex items-center justify-center mb-6">
          <img 
            src="/assets/greek-squad-logo.jpg" 
            alt="Greek Squad Logo" 
            className="h-16 w-16 mr-4 rounded"
            onError={(e) => {
              e.target.style.display = 'none';
            }}
          />
          <div>
            <h1 className="text-4xl font-bold text-blue-900 mb-2">About Greek Squad USA</h1>
            <p className="text-xl text-gray-600">Innovating Technology Solutions Since 2020</p>
          </div>

      {/* Our Services */}
      <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-8 mb-12">
        <h2 className="text-2xl font-bold text-gray-900 mb-6 text-center">Our Services</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          <div className="p-5 rounded-lg bg-gray-50">
            <h3 className="font-semibold text-gray-900 mb-2">Driver & Device Management</h3>
            <p className="text-sm text-gray-600">Automated printer driver detection, updates, and troubleshooting for HP, Canon, Epson, Brother, Samsung, Lexmark, Xerox, and Ricoh.</p>
          </div>
          <div className="p-5 rounded-lg bg-gray-50">
            <h3 className="font-semibold text-gray-900 mb-2">PC Auto-Updates</h3>
            <p className="text-sm text-gray-600">Windows application patching and updates using secure, policy-driven automation (winget integration).</p>
          </div>
          <div className="p-5 rounded-lg bg-gray-50">
            <h3 className="font-semibold text-gray-900 mb-2">Security & Protection</h3>
            <p className="text-sm text-gray-600">Safe Search, malicious domain filtering, Windows Defender checks, firewall controls, and real-time security monitoring.</p>
          </div>
          <div className="p-5 rounded-lg bg-gray-50">
            <h3 className="font-semibold text-gray-900 mb-2">Enterprise Support</h3>
            <p className="text-sm text-gray-600">License management, audit logging, deployment assistance, and SLA-backed support for organizations.</p>
          </div>
          <div className="p-5 rounded-lg bg-gray-50">
            <h3 className="font-semibold text-gray-900 mb-2">Consulting & Onboarding</h3>
            <p className="text-sm text-gray-600">Tailored onboarding, best-practice security hardening, and migration support for Windows 10/11 environments.</p>
          </div>
          <div className="p-5 rounded-lg bg-gray-50">
            <h3 className="font-semibold text-gray-900 mb-2">Customer Success</h3>
            <p className="text-sm text-gray-600">Proactive guidance, knowledge base updates, and dedicated support channels for smooth operations.</p>
          </div>
        </div>
      </div>

      {/* Why Choose Greek Squad USA */}
      <div className="bg-gradient-to-r from-indigo-50 to-purple-50 rounded-lg p-8 mb-12">
        <h2 className="text-2xl font-bold text-gray-900 mb-6 text-center">Why Choose Greek Squad USA</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          <div className="p-5 rounded-lg bg-white border border-gray-200">
            <h3 className="font-semibold text-gray-900 mb-2">Security First</h3>
            <p className="text-sm text-gray-600">From safe browsing and firewall integration to license encryption and audit trails, security is built-in.</p>
          </div>
          <div className="p-5 rounded-lg bg-white border border-gray-200">
            <h3 className="font-semibold text-gray-900 mb-2">Modern UX</h3>
            <p className="text-sm text-gray-600">Professional UI with animations, glass morphism, and responsive design across all Windows devices.</p>
          </div>
          <div className="p-5 rounded-lg bg-white border border-gray-200">
            <h3 className="font-semibold text-gray-900 mb-2">Deep Windows Integration</h3>
            <p className="text-sm text-gray-600">PowerShell/WMI, winget, and Defender Firewall integration for reliable, native operations.</p>
          </div>
          <div className="p-5 rounded-lg bg-white border border-gray-200">
            <h3 className="font-semibold text-gray-900 mb-2">Trusted Support</h3>
            <p className="text-sm text-gray-600">Toll-free hotline and responsive email support from our US-based team.</p>
          </div>
        </div>
      </div>

      {/* Compliance & Trust */}
      <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-8 mb-12">
        <h2 className="text-2xl font-bold text-gray-900 mb-6 text-center">Compliance & Trust</h2>
        <ul className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 list-disc list-inside text-gray-700">
          <li>Code signing and integrity checks for distributed builds</li>
          <li>Session management and secure local storage of license data</li>
          <li>Least-privilege operations; admin required only where necessary</li>
          <li>Transparent logging and export for audits</li>
          <li>Clear Privacy Policy and Terms of Use</li>
          <li>Customer-first support with rapid turnaround</li>
        </ul>
      </div>
        </div>
        <div className="flex items-center justify-center text-blue-600 mb-4">
          <GlobeAltIcon className="h-5 w-5 mr-2" />
          <a 
            href="https://www.greeksquadusa.com" 
            target="_blank" 
            rel="noopener noreferrer"
            className="text-lg hover:text-blue-700 transition-colors"
          >
            www.greeksquadusa.com
          </a>
        </div>
      </div>

      {/* Company Overview */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-12">
        <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-8">
          <div className="flex items-center mb-4">
            <BuildingOfficeIcon className="h-8 w-8 text-blue-600 mr-3" />
            <h2 className="text-2xl font-bold text-gray-900">Our Company</h2>
          </div>
          <p className="text-gray-600 leading-relaxed mb-4">
            Greek Squad USA is a leading technology company specializing in innovative software solutions 
            for businesses and consumers. Founded in 2020, we have been at the forefront of developing 
            cutting-edge applications that simplify complex technical challenges.
          </p>
          <p className="text-gray-600 leading-relaxed">
            Our flagship product, Greek Driver Updater, represents our commitment to providing reliable, 
            secure, and user-friendly solutions that help users maintain their systems efficiently and effectively.
          </p>
        </div>

        <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-8">
          <div className="flex items-center mb-4">
            <CpuChipIcon className="h-8 w-8 text-blue-600 mr-3" />
            <h2 className="text-2xl font-bold text-gray-900">Our Mission</h2>
          </div>
          <p className="text-gray-600 leading-relaxed mb-4">
            To empower users with intelligent, automated solutions that eliminate the complexity of 
            system maintenance and driver management. We believe technology should work seamlessly 
            in the background, allowing users to focus on what matters most.
          </p>
          <div className="flex items-center text-blue-600">
            <HeartIcon className="h-5 w-5 mr-2" />
            <span className="font-medium">Built with passion for excellence</span>
          </div>
        </div>
      </div>

      {/* Product Information */}
      <div className="bg-gradient-to-r from-blue-50 to-indigo-50 rounded-lg p-8 mb-12">
        <div className="text-center mb-8">
          <h2 className="text-3xl font-bold text-blue-900 mb-4">Greek Driver Updater</h2>
          <p className="text-lg text-gray-700 max-w-3xl mx-auto">
            Our premier driver management solution designed specifically for Windows systems, 
            providing automated printer driver detection, updates, and comprehensive system maintenance.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
          <div className="text-center">
            <div className="bg-white rounded-full p-4 w-16 h-16 mx-auto mb-4 shadow-sm">
              <ShieldCheckIcon className="h-8 w-8 text-blue-600" />
            </div>
            <h3 className="font-semibold text-gray-900 mb-2">Secure & Reliable</h3>
            <p className="text-sm text-gray-600">
              Enterprise-grade security with encrypted license management and secure driver downloads
            </p>
          </div>

          <div className="text-center">
            <div className="bg-white rounded-full p-4 w-16 h-16 mx-auto mb-4 shadow-sm">
              <CpuChipIcon className="h-8 w-8 text-blue-600" />
            </div>
            <h3 className="font-semibold text-gray-900 mb-2">Intelligent Detection</h3>
            <p className="text-sm text-gray-600">
              Advanced algorithms detect connected printers and identify the latest compatible drivers
            </p>
          </div>

          <div className="text-center">
            <div className="bg-white rounded-full p-4 w-16 h-16 mx-auto mb-4 shadow-sm">
              <UserGroupIcon className="h-8 w-8 text-blue-600" />
            </div>
            <h3 className="font-semibold text-gray-900 mb-2">User-Friendly</h3>
            <p className="text-sm text-gray-600">
              Intuitive interface designed for users of all technical levels with comprehensive support
            </p>
          </div>
        </div>
      </div>

      {/* Contact Information */}
      <div className="bg-white rounded-lg shadow-sm border border-gray-200 p-8 mb-8">
        <h2 className="text-2xl font-bold text-gray-900 mb-6 text-center">Contact Information</h2>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          <div className="text-center">
            <div className="bg-blue-50 rounded-full p-3 w-12 h-12 mx-auto mb-3">
              <GlobeAltIcon className="h-6 w-6 text-blue-600" />
            </div>
            <h3 className="font-medium text-gray-900 mb-1">Website</h3>
            <a 
              href="https://www.greeksquadusa.com" 
              target="_blank" 
              rel="noopener noreferrer"
              className="text-blue-600 hover:text-blue-700 text-sm"
            >
              www.greeksquadusa.com
            </a>
          </div>

          <div className="text-center">
            <div className="bg-blue-50 rounded-full p-3 w-12 h-12 mx-auto mb-3">
              <EnvelopeIcon className="h-6 w-6 text-blue-600" />
            </div>
            <h3 className="font-medium text-gray-900 mb-1">Email Support</h3>
            <a 
              href="mailto:support@greeksquadusa.com"
              className="text-blue-600 hover:text-blue-700 text-sm"
            >
              support@greeksquadusa.com
            </a>
          </div>

          <div className="text-center">
            <div className="flex items-center">
              <PhoneIcon className="h-6 w-6 text-blue-600" />
            </div>
            <h3 className="font-medium text-gray-900 mb-1">Phone Support</h3>
            <a 
              href="tel:+1-888-401-3698"
              className="text-blue-600 hover:text-blue-700 text-sm"
            >
              +1 (888) 401-3698
            </a>
            <p className="text-xs text-gray-500">Toll-Free Support</p>
          </div>

          <div className="text-center">
            <div className="bg-blue-50 rounded-full p-3 w-12 h-12 mx-auto mb-3">
              <MapPinIcon className="h-6 w-6 text-blue-600" />
            </div>
            <h3 className="font-medium text-gray-900 mb-1">Headquarters</h3>
            <p className="text-gray-600 text-sm">
              Silicon Valley, CA<br />
              United States
            </p>
          </div>
        </div>
      </div>

      {/* Version Information */}
      <div className="bg-gray-50 rounded-lg p-6 text-center">
        <h3 className="text-lg font-semibold text-gray-900 mb-2">Greek Driver Updater</h3>
        <p className="text-gray-600 text-sm mb-2">Version 1.0.0 - Built with Electron & React</p>
        <p className="text-gray-500 text-xs">
          © 2024 Greek Squad USA. All rights reserved. | 
          <a href="#" className="text-blue-600 hover:text-blue-700 ml-1">Privacy Policy</a> | 
          <a href="#" className="text-blue-600 hover:text-blue-700 ml-1">Terms of Use</a>
        </p>
      </div>
    </div>
  );
};

export default AboutUs;
