@echo off
title Creating Portable Greek Driver Updater Package
color 0A

echo.
echo ╔══════════════════════════════════════════════════════════════╗
echo ║           Creating Portable Distribution Package             ║
echo ║                Greek Driver Updater                          ║
echo ║                by Greek Squad USA                            ║
echo ╚══════════════════════════════════════════════════════════════╝
echo.

REM Create portable package directory
set PACKAGE_NAME=Greek-Driver-Updater-Portable
if exist "%PACKAGE_NAME%" rmdir /s /q "%PACKAGE_NAME%"
mkdir "%PACKAGE_NAME%"

echo 📦 Creating portable package...

REM Copy core application files
echo    ✓ Copying application files...
xcopy /E /I /Y "src" "%PACKAGE_NAME%\src\" >nul 2>&1
xcopy /E /I /Y "public" "%PACKAGE_NAME%\public\" >nul 2>&1
copy /Y "package.json" "%PACKAGE_NAME%\" >nul 2>&1
copy /Y "preview.html" "%PACKAGE_NAME%\" >nul 2>&1
copy /Y "tailwind.config.js" "%PACKAGE_NAME%\" >nul 2>&1
copy /Y "postcss.config.js" "%PACKAGE_NAME%\" >nul 2>&1

REM Copy documentation
echo    ✓ Copying documentation...
copy /Y "README.md" "%PACKAGE_NAME%\" >nul 2>&1
copy /Y "DISTRIBUTION_GUIDE.md" "%PACKAGE_NAME%\" >nul 2>&1
copy /Y "READY-FOR-DISTRIBUTION.md" "%PACKAGE_NAME%\" >nul 2>&1

REM Copy website files for deployment
echo    ✓ Copying website files...
xcopy /E /I /Y "website" "%PACKAGE_NAME%\website\" >nul 2>&1

REM Copy system detection and installer
echo    ✓ Copying system tools...
copy /Y "system-detector.js" "%PACKAGE_NAME%\" >nul 2>&1
copy /Y "universal-installer.bat" "%PACKAGE_NAME%\" >nul 2>&1

REM Create launcher script
echo    ✓ Creating launcher...
echo @echo off > "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo title Greek Driver Updater >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo Starting Greek Driver Updater... >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo by Greek Squad USA >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo. >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo Opening application in your default browser... >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo start "" "preview.html" >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo. >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo ✅ Greek Driver Updater is now running! >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo. >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo 📞 Support: +1 (888) 401-3698 >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo 📧 Email: support@greeksquadusa.com >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo echo 🌐 Website: www.greeksquadusa.com >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"
echo timeout /t 3 ^>nul >> "%PACKAGE_NAME%\Launch-Greek-Driver-Updater.bat"

REM Create system requirements checker
echo    ✓ Creating system checker...
echo @echo off > "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo title System Compatibility Checker >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo. >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo ╔══════════════════════════════════════════════════════════════╗ >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo ║              System Compatibility Checker                   ║ >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo ║                Greek Driver Updater                          ║ >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo ╚══════════════════════════════════════════════════════════════╝ >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo. >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo 🔍 Checking system compatibility... >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo. >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo for /f "tokens=4-5 delims=. " %%%%i in ('ver') do set VERSION=%%%%i.%%%%j >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo Windows Version: %%VERSION%% >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo if "%%VERSION%%" geq "10.0" ( >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo     echo ✅ Compatible: Windows 10/11 detected >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo ^) else ( >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo     echo ❌ Not Compatible: Windows 10 or later required >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo ^) >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo. >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo Architecture: %%PROCESSOR_ARCHITECTURE%% >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo echo. >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"
echo pause >> "%PACKAGE_NAME%\Check-System-Compatibility.bat"

REM Create README for the package
echo    ✓ Creating package README...
echo # Greek Driver Updater - Portable Package > "%PACKAGE_NAME%\PACKAGE-README.txt"
echo. >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo ## Quick Start >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo 1. Double-click "Launch-Greek-Driver-Updater.bat" to start the application >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo 2. Or double-click "preview.html" to open directly in your browser >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo. >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo ## Installation Options >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo - Portable: Run directly from this folder >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo - Install: Run "universal-installer.bat" as Administrator >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo - Check Compatibility: Run "Check-System-Compatibility.bat" >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo. >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo ## System Requirements >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo - Windows 10 or later >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo - 4GB RAM (8GB recommended) >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo - Modern web browser >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo - Administrator privileges (for full features) >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo. >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo ## Support >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo Phone: +1 (888) 401-3698 >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo Email: support@greeksquadusa.com >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo Website: www.greeksquadusa.com >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo. >> "%PACKAGE_NAME%\PACKAGE-README.txt"
echo Greek Squad USA - Professional Software Solutions >> "%PACKAGE_NAME%\PACKAGE-README.txt"

echo.
echo ✅ Portable package created successfully!
echo.
echo 📁 Package location: %PACKAGE_NAME%\
echo 📦 Package contents:
echo    - Complete application with all features
echo    - Greek Squad USA branding and logo
echo    - Security features and UI enhancements
echo    - System compatibility checker
echo    - Universal installer
echo    - Website deployment files
echo    - Complete documentation
echo.
echo 🚀 Ready for distribution:
echo    1. Zip the "%PACKAGE_NAME%" folder
echo    2. Upload to your website
echo    3. Share with customers
echo.
echo 📞 Support: +1 (888) 401-3698
echo 🌐 Website: www.greeksquadusa.com
echo.
pause
