@echo off
echo Creating Greek Driver Updater Distribution Package...
echo.

REM Create distribution directory
if not exist "Greek-Driver-Updater-Distribution" mkdir "Greek-Driver-Updater-Distribution"

REM Copy all necessary files
echo Copying application files...
xcopy /E /I /Y "src" "Greek-Driver-Updater-Distribution\src\"
xcopy /E /I /Y "public" "Greek-Driver-Updater-Distribution\public\"
copy /Y "package.json" "Greek-Driver-Updater-Distribution\"
copy /Y "tailwind.config.js" "Greek-Driver-Updater-Distribution\"
copy /Y "postcss.config.js" "Greek-Driver-Updater-Distribution\"
copy /Y "README.md" "Greek-Driver-Updater-Distribution\"
copy /Y "preview.html" "Greek-Driver-Updater-Distribution\"

REM Copy website files
xcopy /E /I /Y "website" "Greek-Driver-Updater-Distribution\website\"

REM Create run script
echo @echo off > "Greek-Driver-Updater-Distribution\run-app.bat"
echo echo Starting Greek Driver Updater... >> "Greek-Driver-Updater-Distribution\run-app.bat"
echo start preview.html >> "Greek-Driver-Updater-Distribution\run-app.bat"

echo.
echo ✅ Distribution package created in: Greek-Driver-Updater-Distribution
echo.
echo Contents:
echo - Complete application source code
echo - Website files for greeksquadusa.com
echo - Preview HTML file
echo - Documentation
echo.
echo To distribute:
echo 1. Zip the Greek-Driver-Updater-Distribution folder
echo 2. Upload to your website
echo 3. Customers can run preview.html to see the app
echo.
pause
