@echo off
echo Building Greek Driver Updater Installer...
echo.

REM Create build directory
if not exist "build" mkdir build

REM Copy all source files to build directory
echo Copying application files...
xcopy /E /I /Y "src" "build\src"
xcopy /E /I /Y "public" "build\public"
copy /Y "package.json" "build\"
copy /Y "*.js" "build\" 2>nul
copy /Y "*.md" "build\" 2>nul

REM Create a simple installer script
echo Creating installer...
echo @echo off > "Greek-Driver-Updater-Setup.bat"
echo echo Installing Greek Driver Updater... >> "Greek-Driver-Updater-Setup.bat"
echo echo. >> "Greek-Driver-Updater-Setup.bat"
echo if not exist "%%PROGRAMFILES%%\Greek Squad USA" mkdir "%%PROGRAMFILES%%\Greek Squad USA" >> "Greek-Driver-Updater-Setup.bat"
echo if not exist "%%PROGRAMFILES%%\Greek Squad USA\Greek Driver Updater" mkdir "%%PROGRAMFILES%%\Greek Squad USA\Greek Driver Updater" >> "Greek-Driver-Updater-Setup.bat"
echo xcopy /E /I /Y "build\*" "%%PROGRAMFILES%%\Greek Squad USA\Greek Driver Updater\" >> "Greek-Driver-Updater-Setup.bat"
echo echo Installation complete! >> "Greek-Driver-Updater-Setup.bat"
echo echo Greek Driver Updater installed to: %%PROGRAMFILES%%\Greek Squad USA\Greek Driver Updater >> "Greek-Driver-Updater-Setup.bat"
echo pause >> "Greek-Driver-Updater-Setup.bat"

echo.
echo ✅ Installer created: Greek-Driver-Updater-Setup.bat
echo.
echo To distribute:
echo 1. Run this installer as Administrator
echo 2. Or use a proper installer tool like NSIS or Inno Setup
echo.
pause
