# Greek Driver Updater

A specialized Windows desktop application that automatically detects and downloads the latest printer drivers for your connected devices. Developed by Greek Squad USA with a focus on seamless driver management for laptops and mobile-connected printers.

## Features

### 🔄 Automatic Driver Detection
- **Smart Brand Recognition**: Automatically identifies printer manufacturers (HP, Canon, Epson, Brother, Samsung, Lexmark, Xerox, Ricoh)
- **One-Click Downloads**: Direct links to official manufacturer driver download pages
- **Real-time Scanning**: Instant detection of connected printers and their current driver status
- **Multi-Device Support**: Works with printers connected via USB, Wi-Fi, or mobile devices

### 🖨️ Comprehensive Printer Management
- **Real-time Status Monitoring**: Detects all connected printers and their operational status
- **Driver Information**: Complete details about installed drivers with version tracking
- **Diagnostic Tools**: 
  - Restart print spooler service
  - Send test pages to verify functionality
  - Troubleshooting wizard for common printer issues
- **Default Printer Management**: Easy identification and switching of default printers

### ⚙️ System Integration
- **Windows Integration**: Uses WMI/PowerShell for system information
- **Comprehensive Logging**: Track all activities and troubleshoot issues
- **Flexible Settings**: Customize automation, notifications, and behavior
- **Modern UI**: Beautiful, responsive interface built with TailwindCSS

## Technology Stack

- **Frontend**: React 18 with modern hooks and components
- **Desktop Framework**: Electron for cross-platform desktop app
- **Styling**: TailwindCSS for modern, responsive design
- **Icons**: Heroicons for consistent iconography
- **Backend**: Node.js with child_process for system commands
- **Windows Integration**: 
  - PowerShell/WMI for printer detection and management
  - Direct manufacturer driver download links
  - `pnputil` for driver operations

## Installation

### Prerequisites
- Windows 10/11
- Node.js 16 or higher
- Administrator privileges (required for printer management)
- Internet connection (for driver downloads)

### Setup
1. Clone or download the project
2. Install dependencies:
   ```bash
   npm install
   ```

3. Run in development mode:
   ```bash
   npm run dev
   ```

4. Build for production:
   ```bash
   npm run build
   npm run electron-build
   ```

## Usage

### Dashboard
- Overview of printer and driver status
- Quick actions for driver scanning and printer management
- Greek Squad USA branding and links

### Driver Updates Tab
- Automatic detection of connected printers
- Brand recognition for major manufacturers
- One-click driver download from official sources

### Printer Tab
- Monitor all connected printers
- Check printer status and drivers
- Run diagnostics and troubleshooting
- Print test pages

### Settings
- Configure automatic update checking
- Set notification preferences
- Enable/disable silent updates
- Customize printer management options

### Logs
- View detailed activity logs
- Filter by log level (error, warning, info, success)
- Search through log entries
- Export logs for troubleshooting

## Security & Permissions

### Administrator Rights Required For:
- Managing printer drivers and settings
- Restarting system services (print spooler)
- Accessing printer hardware information

### Security Features:
- Opens official manufacturer websites for driver downloads
- No automatic driver installation without user consent
- Transparent system command execution
- Local logging only (no external data transmission)
- User confirmation for system changes

## Troubleshooting

### Common Issues:

1. **Printer Not Detected**
   - Verify printer is connected and powered on
   - Check USB/Wi-Fi connection
   - Restart print spooler service
   - Ensure printer drivers are installed

2. **Permission Denied Errors**
   - Run the application as Administrator
   - Check Windows UAC settings
   - Verify printer access permissions

3. **Driver Download Issues**
   - Verify internet connection
   - Check if manufacturer website is accessible
   - Disable popup blockers for driver download pages

4. **Brand Not Recognized**
   - Manually visit manufacturer website
   - Check printer model compatibility
   - Contact Greek Squad USA support

## Development

### Project Structure
```
src/
├── main.js              # Electron main process
├── preload.js           # Electron preload script
├── App.js               # Main React application
├── index.js             # React entry point
├── index.css            # Global styles with Tailwind
└── components/
    ├── Dashboard.js     # System overview
    ├── DriverUpdates.js # Driver detection and download
    ├── PrinterManager.js # Printer operations
    ├── Settings.js      # Configuration panel
    └── Logs.js          # Activity logging
```

### Available Scripts
- `npm start` - Start Electron app
- `npm run dev` - Development mode with hot reload
- `npm run build` - Build React app for production
- `npm run electron-build` - Package Electron app
- `npm run dist` - Create distribution packages

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly on Windows
5. Submit a pull request

## License

MIT License - see LICENSE file for details

## Greek Squad USA

**Developed by Greek Squad USA**
- Website: [www.greeksquadusa.com](https://www.greeksquadusa.com)
- Logo source: [greeksquad.in](https://greeksquad.in)
- Specialized in driver management and system optimization solutions

## Support

For issues and support:
1. Visit [www.greeksquadusa.com](https://www.greeksquadusa.com)
2. Check the troubleshooting section in this README
3. Review application logs within the app
4. Ensure you have administrator privileges
5. Verify Windows version compatibility

---

**Note**: This application requires Windows 10/11 and administrator privileges for full functionality. Internet connection required for driver downloads from manufacturer websites.
