@echo off
title Greek Driver Updater - FTP Upload Script
color 0B

echo.
echo ╔══════════════════════════════════════════════════════════════╗
echo ║              Greek Driver Updater Upload Script             ║
echo ║                  to greeksquadusa.com                        ║
echo ╚══════════════════════════════════════════════════════════════╝
echo.

REM Check if portable package exists
if not exist "Greek-Driver-Updater-Portable" (
    echo ❌ Portable package not found. Please run create-portable-package.bat first.
    pause
    exit /b 1
)

echo 📦 Preparing files for upload...

REM Create ZIP file of portable package
echo    Creating ZIP archive...
powershell -Command "Compress-Archive -Path 'Greek-Driver-Updater-Portable\*' -DestinationPath 'Greek-Driver-Updater-Portable.zip' -Force"

REM Create upload directory structure
if not exist "upload-ready" mkdir "upload-ready"
if not exist "upload-ready\products" mkdir "upload-ready\products"
if not exist "upload-ready\products\driver-updater" mkdir "upload-ready\products\driver-updater"
if not exist "upload-ready\downloads" mkdir "upload-ready\downloads"
if not exist "upload-ready\downloads\driver-updater" mkdir "upload-ready\downloads\driver-updater"

REM Copy files to upload structure
echo    Organizing files for upload...
copy "website\download.html" "upload-ready\products\driver-updater\" >nul
copy "Greek-Driver-Updater-Portable.zip" "upload-ready\downloads\driver-updater\" >nul
copy "universal-installer.bat" "upload-ready\downloads\driver-updater\" >nul

REM Create index redirect for product page
echo ^<^!DOCTYPE html^> > "upload-ready\products\driver-updater\index.html"
echo ^<html^> >> "upload-ready\products\driver-updater\index.html"
echo ^<head^> >> "upload-ready\products\driver-updater\index.html"
echo     ^<meta http-equiv="refresh" content="0; url=download.html"^> >> "upload-ready\products\driver-updater\index.html"
echo     ^<title^>Greek Driver Updater^</title^> >> "upload-ready\products\driver-updater\index.html"
echo ^</head^> >> "upload-ready\products\driver-updater\index.html"
echo ^<body^> >> "upload-ready\products\driver-updater\index.html"
echo     ^<p^>Redirecting to ^<a href="download.html"^>Greek Driver Updater^</a^>...^</p^> >> "upload-ready\products\driver-updater\index.html"
echo ^</body^> >> "upload-ready\products\driver-updater\index.html"
echo ^</html^> >> "upload-ready\products\driver-updater\index.html"

REM Create FTP script
echo    Creating FTP upload script...
echo open greeksquadusa.com > ftp_commands.txt
echo USER_PLACEHOLDER >> ftp_commands.txt
echo PASS_PLACEHOLDER >> ftp_commands.txt
echo binary >> ftp_commands.txt
echo mkdir products >> ftp_commands.txt
echo cd products >> ftp_commands.txt
echo mkdir driver-updater >> ftp_commands.txt
echo cd driver-updater >> ftp_commands.txt
echo put upload-ready\products\driver-updater\download.html download.html >> ftp_commands.txt
echo put upload-ready\products\driver-updater\index.html index.html >> ftp_commands.txt
echo cd / >> ftp_commands.txt
echo mkdir downloads >> ftp_commands.txt
echo cd downloads >> ftp_commands.txt
echo mkdir driver-updater >> ftp_commands.txt
echo cd driver-updater >> ftp_commands.txt
echo put upload-ready\downloads\driver-updater\Greek-Driver-Updater-Portable.zip Greek-Driver-Updater-Portable.zip >> ftp_commands.txt
echo put upload-ready\downloads\driver-updater\universal-installer.bat universal-installer.bat >> ftp_commands.txt
echo quit >> ftp_commands.txt

echo.
echo ✅ Upload package prepared successfully!
echo.
echo 📁 Files ready for upload:
echo    ├── products/driver-updater/download.html
echo    ├── products/driver-updater/index.html  
echo    ├── downloads/driver-updater/Greek-Driver-Updater-Portable.zip
echo    └── downloads/driver-updater/universal-installer.bat
echo.
echo 🌐 Upload Methods:
echo.
echo 1. FTP Upload (Manual):
echo    - Edit ftp_commands.txt with your FTP credentials
echo    - Run: ftp -s:ftp_commands.txt
echo.
echo 2. Web Panel Upload:
echo    - Login to your hosting control panel
echo    - Upload files from 'upload-ready' folder
echo    - Maintain the directory structure
echo.
echo 3. SFTP/FileZilla:
echo    - Use FileZilla or WinSCP
echo    - Upload 'upload-ready' contents to public_html/
echo.
echo 📋 After Upload URLs:
echo    Main Page: https://greeksquadusa.com/products/driver-updater/
echo    Download:  https://greeksquadusa.com/downloads/driver-updater/
echo.
echo 📞 Support: +1 (888) 401-3698
echo 🌐 Website: www.greeksquadusa.com
echo.

REM Prompt for FTP credentials if user wants to upload now
set /p UPLOAD_NOW="Upload now via FTP? (y/n): "
if /i "%UPLOAD_NOW%"=="y" (
    echo.
    set /p FTP_USER="Enter FTP username: "
    set /p FTP_PASS="Enter FTP password: "
    
    REM Replace placeholders in FTP script
    powershell -Command "(Get-Content ftp_commands.txt) -replace 'USER_PLACEHOLDER', '%FTP_USER%' | Set-Content ftp_commands.txt"
    powershell -Command "(Get-Content ftp_commands.txt) -replace 'PASS_PLACEHOLDER', '%FTP_PASS%' | Set-Content ftp_commands.txt"
    
    echo.
    echo 🚀 Starting FTP upload...
    ftp -s:ftp_commands.txt
    
    echo.
    echo ✅ Upload completed!
    echo 🌐 Check: https://greeksquadusa.com/products/driver-updater/
) else (
    echo.
    echo 📋 Manual upload instructions saved in UPLOAD_GUIDE.md
)

echo.
pause
